﻿//////////////////////////////////////////////
// GraphicsEngine.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class ProgramTrackersHolder ;
}

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../Dll/DllDefines.h"

#include "../Configurations/Configuration.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT GraphicsEngine final
	{
		public :

			// Constructor, destructor
			GraphicsEngine (bool isSingleton) noexcept ;
			~GraphicsEngine () ;

			// Getters
			nkGraphics::System* getGraphicsSystem () const ;
			ProgramTrackersHolder* getProgramTrackersHolder () const ;

			// Lifetime
			bool initialize (const Configuration& config = Configuration()) ;
			void shutdown () ;

		private :

			// Attributes
			// Underlying system
			nkMemory::UniquePtr<nkGraphics::System> _graphicsSystem ;

			// Utils
			nkMemory::UniquePtr<ProgramTrackersHolder> _programTrackersHolder ;

			// Flags
			bool _isSingleton ;
			bool _hasExternalGraphicsSystem ;
	} ;
}